package com.jumeirah.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jumeirah.common.entity.MerchantRole;
import com.jumeirah.common.mapper.MerchantRoleMapper;
import com.jumeirah.common.param.MerchantRolePageParam;
import com.jumeirah.common.service.MerchantRoleService;
import com.jumeirah.common.vo.MerchantRoleQueryVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 商家角色 服务实现类
 *
 * @author wei
 * @since 2020-09-28
 */
@Slf4j
@Service
public class MerchantRoleServiceImpl extends BaseServiceImpl<MerchantRoleMapper, MerchantRole> implements MerchantRoleService {

@Autowired
private MerchantRoleMapper merchantRoleMapper;

@Transactional(rollbackFor = Exception.class)
@Override
public boolean saveMerchantRole(MerchantRole merchantRole)throws Exception{
        return super.save(merchantRole);
        }

@Transactional(rollbackFor = Exception.class)
@Override
public boolean updateMerchantRole(MerchantRole merchantRole)throws Exception{
        return super.updateById(merchantRole);
        }

@Transactional(rollbackFor = Exception.class)
@Override
public boolean deleteMerchantRole(Long id)throws Exception{
        return super.removeById(id);
        }

    @Override
    public MerchantRoleQueryVo getMerchantRoleById(Long id)throws Exception{
            return merchantRoleMapper.getMerchantRoleById(id);
            }

@Override
public Paging<MerchantRoleQueryVo> getMerchantRolePageList(MerchantRolePageParam merchantRolePageParam)throws Exception{
        Page<MerchantRoleQueryVo> page=new PageInfo<>(merchantRolePageParam,OrderItem.desc(getLambdaColumn(MerchantRole::getCreateTime)));
            IPage<MerchantRoleQueryVo> iPage= merchantRoleMapper.getMerchantRolePageList(page, merchantRolePageParam);
        return new Paging<MerchantRoleQueryVo>(iPage);
        }

        }
