package com.jumeirah.common.service;

import com.jumeirah.common.entity.ContactStaff;
import com.jumeirah.common.param.ContactStaffPageParam;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import com.jumeirah.common.param.ContactStaffQueryVo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 服务类
 *
 * @author xxx
 * @since 2020-10-27
 */
public interface ContactStaffService extends BaseService<ContactStaff> {

    /**
     * 保存
     *
     * @param contactStaff
     * @return
     * @throws Exception
     */
    boolean saveContactStaff(ContactStaff contactStaff) throws Exception;

    /**
     * 修改
     *
     * @param contactStaff
     * @return
     * @throws Exception
     */
    boolean updateContactStaff(ContactStaff contactStaff) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteContactStaff(Long id) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    ContactStaffQueryVo getContactStaffById(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param contactStaffPageParam
     * @return
     * @throws Exception
     */
    Paging<ContactStaffQueryVo> getContactStaffPageList(ContactStaffPageParam contactStaffPageParam) throws Exception;

}
