package com.wecloud.im.user.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author wenzhida
 * @Date 2022/2/21 22:57
 * @Description 重置密码接口
 */
@Data
public class ResetPasswordParam implements Serializable {

    private static final long serialVersionUID = 387632352343954534L;

    /**
     * 电话号码
     */
    @NotNull(message = "电话号码不可为空")
    @ApiModelProperty("电话号码")
    private String phone;

    /**
     * 验证码
     */
    @NotNull(message = "验证码不可为空")
    @ApiModelProperty("验证码")
    private String verifyCode;

    /**
     * 密码
     */
    @NotNull(message = "密码不可为空")
    @ApiModelProperty("密码")
    private String password;

}
