package com.wecloud.im.controller;

import com.wecloud.im.param.GetReadersParam;
import com.wecloud.im.param.ImHistoryMessagePageParam;
import com.wecloud.im.param.MsgDeleteParam;
import com.wecloud.im.param.add.ImMsgRecall;
import com.wecloud.im.param.add.ImMsgUpdate;
import com.wecloud.im.service.ImMessageService;
import com.wecloud.im.vo.ImMessageOfflineListVo;
import com.wecloud.im.vo.OfflineMsgDto;
import com.wecloud.im.vo.ReaderList;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 消息存储表 控制器
 *
 * @author wei
 * @since 2021-04-29
 */
@Slf4j
@RestController
@RequestMapping("/imMessage")
@Api(value = "消息存储表API", tags = {"消息存储表"})
public class ImMessageController extends BaseController {

    @Autowired
    private ImMessageService imMessageService;

    /**
     * 消息撤回
     */
    @PostMapping("/withdraw")
    @ApiOperation(value = "消息撤回", notes = "只能撤回客户端自己发送的消息")
    public ApiResult<Boolean> withdrawMsg(@RequestBody ImMsgRecall imMsgRecall) throws Exception {
        return imMessageService.withdrawMsg(imMsgRecall);
    }

    /**
     * 删除消息
     */
    @PostMapping("/delete")
    @ApiOperation(value = "删除消息", notes = "单条消息与批量消息删除共用")
    public ApiResult<Boolean> deleteMsg(@RequestBody MsgDeleteParam param) {
        if(param == null) {
            return ApiResult.fail(ApiCode.PARAMETER_EXCEPTION, null);
        }
        if (CollectionUtils.isEmpty(param.getMsgIds())) {
            return ApiResult.fail("请选择要删除");
        }
        return imMessageService.deleteMsg(param);
    }

    /**
     * 修改消息体
     */
    @PostMapping("/updateMsgById")
    @ApiOperation(value = "修改消息体", notes = "只能修改客户端自己发送的消息")
    public ApiResult<Boolean> updateMsgById(@RequestBody ImMsgUpdate imMsgUpdate) throws Exception {
        return imMessageService.updateMsgById(imMsgUpdate);
    }

    /**
     * 离线消息列表
     */
    @PostMapping("/offlineList")
    @ApiOperation(value = "离线消息列表")
    public ApiResult<List<ImMessageOfflineListVo>> getOfflineList() throws Exception {
        List<ImMessageOfflineListVo> offlineList = imMessageService.getOfflineList();
        return ApiResult.ok(offlineList);
    }

    /**
     * 查询某个会话历史消息分页列表
     */
    @PostMapping("/getHistoryMsg")
    @OperationLog(name = "查询某个会话历史消息分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "查询某个会话历史消息分页列表")
    public ApiResult<Paging<OfflineMsgDto>> getHistoryMsg(@Validated @RequestBody ImHistoryMessagePageParam imHistoryMessagePageParam) throws Exception {
        Paging<OfflineMsgDto> paging = imMessageService.getHistoryMsgConversationId(imHistoryMessagePageParam);
        return ApiResult.ok(paging);
    }

    /**
     * 查询某个消息已读client列表和未读client
     */
    @PostMapping("/getReaders")
    @ApiOperation(value = "查询某个消息已读client列表和未读client")
    public ApiResult<ReaderList> getReaders(@Validated @RequestBody GetReadersParam param) {
        ReaderList readerList = imMessageService.getReaders(param);
        return ApiResult.ok(readerList);
    }

}

