package com.sien.common.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <pre>
 * 开通会员参数对象
 * </pre>
 *
 * @author hewei
 * @date 2021-02-25
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "VipOpenParam")
public class VipOpenParam implements Serializable {
    private static final long serialVersionUID = 1L;

//    @ApiModelProperty("开通会员金额")
//    private BigDecimal money;

    @NotNull(message = "开通多久不能为空")
    @ApiModelProperty("开通多少年")
    private Integer years;

    @NotBlank(message = "会员等级id不能为空")
    @ApiModelProperty("会员等级id,传入由会员列表接口返回的id")
    private Long vipLevelId;

    @NotBlank(message = "不能为空")
    @ApiModelProperty("是否代替他人开通")
    private Boolean isReplace;

    @ApiModelProperty("捐款接收用户手机号,当isAgent=1为必填")
    private String userPhone;

    @ApiModelProperty("手机区号,当isAgent=1为必填")
    private String phoneArea;

}
