package com.jumeirah.common.controller;

import com.jumeirah.common.entity.McPlain;
import com.jumeirah.common.param.McPlainPageParam;
import com.jumeirah.common.vo.McPlainQueryVo;
import com.jumeirah.common.service.McPlainService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 商家飞机表 控制器
 *
 * @author xxx
 * @since 2020-10-19
 */
/*@Slf4j
@RestController
@RequestMapping("/mcPlain")
@Api(value = "商家飞机表API", tags = {"商家飞机表"})*/
public class McPlainController extends BaseController {

    @Autowired
    private McPlainService mcPlainService;

    /**
     * 添加商家飞机表
     */
    @PostMapping("/add")
    @OperationLog(name = "添加商家飞机表", type = OperationLogType.ADD)
    @ApiOperation(value = "添加商家飞机表")
    public ApiResult<Boolean> addMcPlain(@Validated(Add.class) @RequestBody McPlain mcPlain) throws Exception {
        boolean flag = mcPlainService.saveMcPlain(mcPlain);
        return ApiResult.result(flag);
    }

    /**
     * 修改商家飞机表
     */
    @PostMapping("/update")
    @OperationLog(name = "修改商家飞机表", type = OperationLogType.UPDATE)
    @ApiOperation(value = "修改商家飞机表")
    public ApiResult<Boolean> updateMcPlain(@Validated(Update.class) @RequestBody McPlain mcPlain) throws Exception {
        boolean flag = mcPlainService.updateMcPlain(mcPlain);
        return ApiResult.result(flag);
    }

    /**
     * 删除商家飞机表
     */
    @PostMapping("/delete/{id}")
    @OperationLog(name = "删除商家飞机表", type = OperationLogType.DELETE)
    @ApiOperation(value = "删除商家飞机表")
    public ApiResult<Boolean> deleteMcPlain(@PathVariable("id") Long id) throws Exception {
        boolean flag = mcPlainService.deleteMcPlain(id);
        return ApiResult.result(flag);
    }

    /**
     * 获取商家飞机表详情
     */
    @GetMapping("/info/{id}")
    @OperationLog(name = "商家飞机表详情", type = OperationLogType.INFO)
    @ApiOperation(value = "商家飞机表详情")
    public ApiResult<McPlainQueryVo> getMcPlain(@PathVariable("id") Long id) throws Exception {
        McPlainQueryVo mcPlainQueryVo = mcPlainService.getMcPlainById(id);
        return ApiResult.ok(mcPlainQueryVo);
    }

    /**
     * 商家飞机表分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "商家飞机表分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "商家飞机表分页列表")
    public ApiResult<Paging<McPlainQueryVo>> getMcPlainPageList(@Validated @RequestBody McPlainPageParam mcPlainPageParam) throws Exception {
        Paging<McPlainQueryVo> paging = mcPlainService.getMcPlainPageList(mcPlainPageParam);
        return ApiResult.ok(paging);
    }

}

