package com.sien.common.tillo.app_ws.service;


import com.sien.common.tillo.app_ws.model.ResponseModel;
import com.sien.common.tillo.app_ws.model.ResultStatus;
import com.sien.common.tillo.app_ws.model.request.ReceiveModel;

/**
 * @Description ws响应数据，各种状态码封装
 * @Author hewei hwei1233@163.com
 * @Date 2019-12-05
 */
public interface WriteDataService {

    /**
     * 可自定义状态码 带data
     *
     * @param requestModel
     * @param resultStatus
     * @param data
     * @param userId
     * @param language
     */
    void dataAndStatus(ReceiveModel requestModel, ResultStatus resultStatus, Object data, Long userId, String language);

    /**
     * 固定"成功"状态码 带data
     *
     * @param requestModel
     * @param data
     * @param userId
     * @param language
     */
    void successAndData(ReceiveModel requestModel, Object data, Long userId, String language);

    /**
     * 固定"成功"状态码 无data
     *
     * @param requestModel
     * @param resultStatus
     * @param userId
     * @param language
     */
    void nullDataSuccess(ReceiveModel requestModel, ResultStatus resultStatus, Long userId, String language);

    /**
     * 固定"参数错误"状态码 无data
     *
     * @param requestModel
     * @param userId
     * @param language
     */
    void paramErrorAndNullData(ReceiveModel requestModel, Long userId, String language);

    /**
     * 调用ws处理响应逻辑
     *
     * @param responseModel
     * @param userId
     */
    void write(ResponseModel responseModel, Long userId);



}
