package com.sien.common.tillo.app_ws.receive;

import com.alibaba.fastjson.JSON;
import com.sien.common.tillo.app_ws.enums.WsRequestCmdEnum;
import com.sien.common.tillo.app_ws.model.request.ReceiveModel;
import com.sien.common.tillo.app_ws.service.WriteDataService;
import com.sien.common.tillo.app_ws.strategy.AbstractReceiveStrategy;
import com.sien.common.tillo.app_ws.strategy.ReceiveStrategyContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @Description ws 数据接收 转换类
 * @Author hewei hwei1233@163.com
 * @Date 2019-12-03
 */
@Service
public class ReadWsData {
    private static Logger log = LoggerFactory.getLogger(ReadWsData.class);

    // idea此处报红 属于正常
//    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Autowired
    private ReceiveStrategyContext receiveStrategyContext;

    @Resource
    private WriteDataService writeDataService;

    private static final String PING = "p";

    /**
     * 在此开始进入业务流程子线程，将不占netty的io线程
     *
     * @param data
     * @param userId
     * @param language
     * @throws Exception
     */
    public void convertModel(String data, Long userId, String language) {


        if (PING.equals(data)) {
            log.debug("收到心跳：" + userId);
            return;
        }

        ReceiveModel requestModel = JSON.parseObject(data, ReceiveModel.class);
        if (null == requestModel || null == requestModel.getPath()) {
            return;
        }

        try {
//            User user = userService.findById(userId);
            this.doProcess(language, requestModel);

        } catch (Exception e) {
            log.error("系统繁忙:" + data + ",userId:" + userId, e);
//            writeDataService.nullDataSuccess(requestModel, ResultStatus.SYS_BUSY, userId, language);
        }

    }

    private void doProcess(String language, ReceiveModel requestModel) {
        WsRequestCmdEnum wsRequestUriPathEnum = WsRequestCmdEnum.getByCode(requestModel.getPath());
        // 使用策略模式， 根据不同类型请求调用不同实现类
        AbstractReceiveStrategy receiveStrategy = receiveStrategyContext.getStrategy(wsRequestUriPathEnum);
        receiveStrategy.process(requestModel, language);
    }


}
