package com.sien.common.tillo.app_ws.model;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 自定义请求状态码
 *
 * @author ScienJus
 * @date 2015/7/15.
 */
@Getter
@AllArgsConstructor
public enum ResultStatus {

    /**
     * 成功
     */
    SUCCESS(200, "Success", "成功"),
    PRIVILEGE_IS_ERROR(401, "Unauthorized", "未授权限，请联系管理员");

    /**
     * 返回码
     */
    private int code;

    /**
     * 默认返回英文结果描述 en
     */
    private String message;

    /**
     * 返回中文结果描述 zh_simple
     */
    private String zhMessage;

}


