package com.sien.common.service;

import io.geekidea.springbootplus.framework.common.api.ApiResult;

public interface AppSmsService {

    void deleteRegisterCode(String area, String number);

    void deleteUpdatePhoneCode(String area, String number);

    void deleteUpdatePhoneCodeNew(String area, String number);

    /**
     * 获取注册验证码
     */
    ApiResult<Object> registerOrLoginCode(String phoneArea, String phone);

    ApiResult<Object> updatePhoneCodeSendToOld() throws Exception;

    /**
     * 修改手机号,向新手机号发验证码
     */
    ApiResult<Object> updatePhoneCodeSendToNew(String phoneArea, String phone);


    /**
     * 修改手机号,校验旧手机验证码
     */
    ApiResult<Boolean> checkPhoneCodeOld(String code) throws Exception;


    /**
     * 获取注册验证码
     */
    ApiResult LoginType(String area, String number);

    /**
     * 校验注册验证码
     *
     * @param area
     * @param number
     * @param code
     * @return
     */
    boolean equalsRegisterCode(String area, String number, String code);

    boolean equalsUpdatePhoneCodeOld(String area, String number, String code);

    boolean equalsUpdatePhoneCodeNew(String area, String number, String code);

    /**
     * 校验验登陆证码
     *
     * @param area
     * @param number
     * @param code
     * @return
     */
    boolean equalsLoginCode(String area, String number, String code);

}
