package com.sien.common.push.umeng;

import com.sien.common.factory.PushService;
import com.sien.common.push.umeng.android.AndroidNotification;
import lombok.SneakyThrows;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * @author: JJww
 * @Date:2020/11/5
 */
@Component
public class UmengAndroidPushServiceImpl extends AndroidNotification implements PushService {

    @Autowired
    private PushClient pushClient;

    private static final String APP_KEY = "5f963f3ea1491772a2aef713";

    private static final String APP_MASTER_SECRET = "ti5gomxtvmkgehmwgtbq9rtsfhy0khsi";

    @PostConstruct
    public void init() throws Exception {
        setAppMasterSecret(APP_MASTER_SECRET);
        setPredefinedKeyValue("appkey", APP_KEY);
    }

    @Override
    @SneakyThrows
    public void unicast(String deviceToken) {
        this.setTitle("您有一条新信息");
        this.setText("");
        this.goAppAfterOpen();
        this.setPredefinedKeyValue("device_tokens", deviceToken);
        this.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);
        this.setProductionMode();
        this.setExtraField("pushType", "1");//自定义字段 推送类型:客服消息
        this.setPredefinedKeyValue("type", "unicast");//单播
        pushClient.send(this);
    }

    @Override
    public void unicast(String deviceToken, String pushType, String title) throws Exception {

        this.setTitle(title);
        this.setText("");
        this.goAppAfterOpen();
        this.setPredefinedKeyValue("device_tokens", deviceToken);
        this.setDisplayType(AndroidNotification.DisplayType.NOTIFICATION);
        this.setProductionMode();
        this.setExtraField("pushType", pushType);//自定义字段 推送类型:客服消息
        this.setPredefinedKeyValue("type", "unicast");//单播
        pushClient.send(this);

    }


}
