package com.wecloud.im.tillo.app_ws.strategy;

import com.wecloud.im.tillo.app_ws.enums.WsRequestCmdEnum;
import com.wecloud.im.tillo.app_ws.utils.SpringBeanUtils;
import org.springframework.util.CollectionUtils;

import java.util.Map;

/**
 * @Description 策略模式 上下文
 * 维护指令码与策略实现的对应
 * @Author hewei hwei1233@163.com
 */
public class ReceiveStrategyContext {

    private Map<WsRequestCmdEnum, Class> strategyMap;

    public ReceiveStrategyContext(Map<WsRequestCmdEnum, Class> strategyMap) {
        this.strategyMap = strategyMap;
    }

    public AbstractReceiveStrategy getStrategy(WsRequestCmdEnum wsRequestPathEnum) {

        if (wsRequestPathEnum == null) {
            throw new IllegalArgumentException("not fond enum");
        }

        if (CollectionUtils.isEmpty(strategyMap)) {
            throw new IllegalArgumentException("strategy map is empty,please check you strategy package path");
        }

        Class aClass = strategyMap.get(wsRequestPathEnum);

        if (aClass == null) {
            throw new IllegalArgumentException("not fond strategy for type:" + wsRequestPathEnum.getCmdCode());
        }

        return (AbstractReceiveStrategy) SpringBeanUtils.getBean(aClass);
    }
}
