package io.geekidea.springbootplus.test;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.crypto.digest.MD5;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.service.ImApplicationService;
import com.wecloud.im.service.ImClientService;
import com.wecloud.im.ws.utils.RedisUtils;
import io.geekidea.springbootplus.framework.shiro.util.JwtUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.time.Duration;

/**
 * 生成测试appkey与appSecret对,并存入数据库
 */
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class LoginTest {

    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    private StringRedisTemplate redisTemplate;

    @Autowired
    private ImApplicationService imApplicationService;

    @Autowired
    private ImClientService imClientService;

    /**
     * 根据客户方生成签名字符串 验证通过则下发token
     *
     * @param timestemp
     * @param clientId
     * @param appKey
     * @param sign
     * @return
     * @throws Exception
     */
    private String getToken(String timestemp, String clientId, String appKey, String sign) throws Exception {

        //  根据appKey从数据库查询密钥
        ImApplication imApplication = imApplicationService.getOne(
                new QueryWrapper<ImApplication>().lambda().eq(ImApplication::getAppKey, appKey)
        );

        // 生成以数据库为准的签名
        String mySign = new MD5().digestHex(timestemp + clientId + imApplication.getAppKey() + imApplication.getAppSecret());

        // 验证签名
        if (mySign.equals(sign)) {
            System.out.println("一致" + mySign);
//            return null;
//
//        }
//
//        // 判断client是否存在
//        ImClient client = imClientService.getOne(new QueryWrapper<ImClient>().lambda()
//                .eq(ImClient::getFkAppid, imApplication.getId())
//                .eq(ImClient::getClientId, clientId));
//
//        if (client == null) {
//            System.out.println("不存在");
//
//            ImClient imClient = new ImClient();
//            imClient.setId(new Snowflake(1L, 1L).nextId());
//            imClient.setFkAppid(imApplication.getId());
//            imClient.setClientId(clientId);
//            imClientService.save(imClient);
//
//        } else {
//            System.out.println("存在");
//        }
//
//        // 生成token
//        String generateToken = JwtUtil.generateToken(clientId, appKey, imApplication.getAppSecret(), Duration.ofDays(99999));
//
//        //  保存redis
//        redisTemplate.opsForValue().set("client:" + imApplication.getAppKey() + ":" + clientId, generateToken);
//        return generateToken;
//    }
//
//    @Test
//    public void test() throws Exception {
//        // 时间戳
//        String timestamp = "1629274899016";
//        String clientId = "aaaaa2";
//        String sign = "a404fe25d383eb154b3b527f7213b35a";
//
//
//        String appKey = "QNtP3EjtLw26ekt0";
//        String token = getToken(timestamp, clientId, appKey, sign);
//        System.out.println("token:\n" + token);
//    }
//}
