package com.wecloud.im.ws.strategy;

import com.wecloud.im.ws.enums.WsRequestCmdEnum;
import com.wecloud.im.ws.utils.SpringBeanUtils;
import org.springframework.util.CollectionUtils;

import java.util.Map;

/**
 * @Description 策略模式 上下文
 * 维护指令码与策略实现的对应
 * @Author hewei hwei1233@163.com
 */
public class ImCmdContext {

    private final Map<WsRequestCmdEnum, Class> strategyMap;

    public ImCmdContext(Map<WsRequestCmdEnum, Class> strategyMap) {
        this.strategyMap = strategyMap;
    }

    public AbstractImCmd getStrategy(WsRequestCmdEnum wsRequestPathEnum) {

        if (wsRequestPathEnum == null) {
            throw new IllegalArgumentException("not fond enum");
        }

        if (CollectionUtils.isEmpty(strategyMap)) {
            throw new IllegalArgumentException("strategy map is empty,please check you strategy package path");
        }

        Class aClass = strategyMap.get(wsRequestPathEnum);

        if (aClass == null) {
            throw new IllegalArgumentException("not fond strategy for type:" + wsRequestPathEnum.getCmdCode());
        }

        return (AbstractImCmd) SpringBeanUtils.getBean(aClass);
    }
}
