package com.wecloud.im.sdk.common;

import cn.hutool.crypto.digest.MD5;

/**
 * 请求参数签名
 * @Author luozh
 * @Date 2022年04月13日 14:24
 * @Version 1.0
 */
public class RequestParamSigner {

    /**
     * 签名
     * @Author luozh
     * @Date 2022年04月13日 02:33:18
     * @param timestamp 时间戳
     * @param clientId client客户端id
     * @param appKey appKey
     * @param appSecret 密钥
     * @param platform 客户端平台: 1 web, 2 安卓, 3 ios, 4 pc-win, 5 pc-macOs
     * @Return
     */
    public static String sign(String timestamp, String clientId, String appKey, String appSecret, String platform) {
        return new MD5().digestHex(timestamp + clientId + appKey + appSecret + platform);
    }

    /**
     * qiangming
     * @Author luozh
     * @Date 2022年04月13日 02:33:30
     * @param clientId client客户端id
     * @param appKey appKey
     * @param appSecret 密钥
     * @param platform 客户端平台: 1 web, 2 安卓, 3 ios, 4 pc-win, 5 pc-macOs
     * @Return
     */
    public static String sign(String clientId, String appKey, String appSecret, String platform) {
        long timestamp = System.currentTimeMillis();
        return new MD5().digestHex(timestamp + "" + clientId + appKey + appSecret + platform);
    }
}
