package com.wecloud.im.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.wecloud.im.entity.ImConversation;
import com.wecloud.im.param.ImConversationPageParam;
import com.wecloud.im.param.ImConversationQueryVo;
import com.wecloud.im.param.add.ImClientLeaveConversation;
import com.wecloud.im.param.add.ImClientToConversation;
import com.wecloud.im.param.add.ImConversationAttrUpdate;
import com.wecloud.im.param.add.ImConversationCreate;
import com.wecloud.im.param.add.ImConversationDisplayUpdate;
import com.wecloud.im.param.add.ImConversationNameUpdate;
import com.wecloud.im.param.add.ImConversationRestApiCreate;
import com.wecloud.im.vo.ImConversationCreateVo;
import com.wecloud.im.vo.MyConversationListVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

import java.util.List;

/**
 * 会话表 服务类
 *
 * @author wei
 * @since 2021-05-07
 */
public interface ImConversationService extends BaseService<ImConversation> {

    /**
     * 保存
     *
     * @param imConversation
     * @return
     * @throws Exception
     */
    boolean saveImConversation(ImConversation imConversation) throws Exception;


    /**
     * 创建会话
     *
     * @param imConversationCreate
     * @return
     */
    ApiResult<ImConversationCreateVo> createImConversation(ImConversationCreate imConversationCreate) throws JsonProcessingException;

    ApiResult<ImConversationCreateVo> createImConversationRestApi(ImConversationRestApiCreate imConversationRestApiCreate, String appkey, String appSecret) throws JsonProcessingException;


    /**
     * 将用户添加进会话
     *
     * @param imClientToConversation
     * @return
     * @throws JsonProcessingException
     */
    ApiResult<Boolean> addClientToConversation(ImClientToConversation imClientToConversation);

    /**
     * 将client从会话移除
     *
     * @param imClientToConversation
     * @return
     */
    ApiResult<Boolean> delClientToConversation(ImClientToConversation imClientToConversation) throws Exception;

    /**
     * client退出会话
     */
    ApiResult<Boolean> leaveConversation(ImClientLeaveConversation imClientToConversation) throws Exception;

    /**
     * 添加或修改会话名称
     */
    ApiResult<Boolean> saveOrUpdateName(ImConversationNameUpdate imConversationNameUpdate) throws Exception;

    /**
     * 添加或修改会话拓展字段
     */
    ApiResult<Boolean> saveOrUpdateAttr(ImConversationAttrUpdate imConversationAttrUpdate) throws Exception;

    /**
     * 修改
     *
     * @param imConversation
     * @return
     * @throws Exception
     */
    boolean updateImConversation(ImConversation imConversation) throws Exception;

    /**
     * 修改为 是否单向隐藏会话","云端聊天记录不删除;假设有A和B两个用户,A删会话,B还能发; 如果B发了消息,A这边要重新把会话显示出来,并能显示之前的聊天记录"
     *
     * @return
     * @throws Exception
     */
    boolean updateDisplayConversation(ImConversationDisplayUpdate imConversationDisplayUpdate) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    ImConversationQueryVo getImConversationById(Long id) throws Exception;

    MyConversationListVo getImConversationAndMsgCountById(Long clientId, Long conversationId);


    MyConversationListVo getImConversationInfoById(Long id) throws Exception;
    MyConversationListVo getImConversationInfoByIdForServerApi(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param imConversationPageParam
     * @return
     * @throws Exception
     */
    Paging<ImConversationQueryVo> getImConversationPageList(ImConversationPageParam imConversationPageParam) throws
            Exception;


    /**
     * 查询用户加入的所有会话 与每个会话的未读条数
     *
     * @return
     * @throws Exception
     */
    List<MyConversationListVo> getMyImConversationListAndMsgCount() throws Exception;

    /**
     * 获取加入的所有会话
     *
     * @return
     * @throws Exception
     */
    List<ImConversation> getMyImConversationList() throws Exception;


    /**
     * 判断两个客户端是否存在会话
     *
     * @param clientId1
     * @param clientId2
     * @return
     */
    Integer getRepetitionConversation(Long clientId1, Long clientId2);

    /**
     * 判断重复会话中的Attributes是否一样
     *
     * @param clientId1
     * @param clientId2
     * @param attributes
     * @return 大于等于1为有重复会话
     */
    Long getRepetitionConversationAttributes(Long clientId1, Long clientId2, String attributes);


}
