package com.wecloud.netty.dispatch.util;

import java.lang.reflect.Modifier;

/**
 * @author lixiaozhong
 */
public class ClassUtil {

	/**
	 * 是否可被实例化
	 *
	 * @param classType
	 * @return
	 */
	public static boolean isCanInstance(Class<?> classType) {
		boolean can = true;
		boolean isAbstract = Modifier.isAbstract(classType.getModifiers());
		if (classType.isAnnotation()) {
			can = false;
		} else if (classType.isEnum()) {
			can = false;
		} else if (classType.isInterface()) {
			can = false;
		} else if (isAbstract) {
			can = false;
		} else if (classType.isArray()) {
			can = false;
		}
		return can;
	}
}
