package com.wecloud.im.biz.scheduled;

import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import com.wecloud.im.biz.module.rtc.service.RtcService;

/**
 * @Author Future
 * @Date 2022/6/3 11:43
 * @Description 单人rtc定时器调度
 */
@Slf4j
@Component
public class SingleRtcScheduled {

    @Resource
    private RtcService rtcService;

    /**
     * 呼叫异常停止处理 查出正在通话的记录，检测是否在线，如未在线超过5次，按断线处理
     */
    @Scheduled(cron = "*/13 * * * * ?")
    public void abnormalDisconnect() {
        log.info("单人音视频异常断线处理开始...");
        rtcService.abnormalDisconnect();
    }


}
