package com.wecloud.im.biz.module.thousandchat.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

import javax.validation.constraints.NotNull;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.wecloud.can.core.base.entity.BaseEntity;

/**
 * @author lixiaozhong
 * 消息最新已读寻址表
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@TableName("im_msg_read_lastest")
@ApiModel(value = "ImMsgReadLastest对象")
public class ImMsgReadLastest extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "主键id不能为空")
    @ApiModelProperty("主键id")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("读取时间")
    private Date readTime;

    @ApiModelProperty("接收时间")
    private Date receiveTime;

    @NotNull(message = "应用appid不能为空")
    @ApiModelProperty("应用appid")
    private Long fkAppid;

    @NotNull(message = "接收客户端id不能为空")
    @ApiModelProperty("接收客户端id")
    private Long fkClientId;

    @NotNull(message = "会话id不能为空")
    @ApiModelProperty("会话id")
    private Long fkConversationId;

    @ApiModelProperty("最后一条已接收消息id")
    private Long fkReceiveMsgId;

    @ApiModelProperty("最后一条已读消息id")
    private Long fkReadMsgId;

}
