package com.wecloud.im.biz.module.multimeet.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.wecloud.can.core.enums.ApiCode;
import com.wecloud.can.core.util.ApiResult;
import com.wecloud.im.biz.module.multimeet.entity.response.MultiMeetAgreeResponse;
import com.wecloud.im.biz.module.multimeet.entity.response.MultiMeetBusyResponse;
import com.wecloud.im.biz.module.multimeet.entity.response.MultiMeetInviteResponse;
import com.wecloud.im.biz.module.multimeet.entity.response.MultiMeetLeaveResponse;
import com.wecloud.im.biz.module.multimeet.entity.response.MultiMeetRejectResponse;
import com.wecloud.im.biz.module.multimeet.service.WsMultiMeetWrite;
import com.wecloud.im.server.enums.WsMultiMeetResponseSubCmdEnum;
import com.wecloud.im.server.enums.WsResponseCmdEnum;
import com.wecloud.im.server.model.WsResponse;
import com.wecloud.im.server.sender.ChannelSender;

/**
 * @Author wenzhida
 * @Date 2022/3/7 22:26
 * @Description 多人音视频长连接下发
 */
@Service
public class WsMultiMeetWriteImpl implements WsMultiMeetWrite {

    @Autowired
    private ChannelSender channelSender;

    @Override
    public void invite(MultiMeetInviteResponse multiMeetInviteResponse, Long toFkClientId) {
        multiMeetInviteResponse.setSubCmd(WsMultiMeetResponseSubCmdEnum.INVITE.getCmdCode());

        //  向接收方推送
        WsResponse<MultiMeetInviteResponse> responseModel = new WsResponse<>();
        responseModel.setCmd(WsResponseCmdEnum.MULTI_MEET_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(multiMeetInviteResponse);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, toFkClientId);
    }

    @Override
    public void reject(MultiMeetRejectResponse multiMeetRejectResponse, Long toFkClientId) {
        multiMeetRejectResponse.setSubCmd(WsMultiMeetResponseSubCmdEnum.REJECT.getCmdCode());

        //  向接收方推送
        WsResponse<MultiMeetRejectResponse> responseModel = new WsResponse<>();
        responseModel.setCmd(WsResponseCmdEnum.MULTI_MEET_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(multiMeetRejectResponse);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, toFkClientId);
    }

    @Override
    public void agree(MultiMeetAgreeResponse multiMeetAgreeResponse, Long toFkClientId) {
        multiMeetAgreeResponse.setSubCmd(WsMultiMeetResponseSubCmdEnum.AGREE.getCmdCode());

        //  向接收方推送
        WsResponse<MultiMeetAgreeResponse> responseModel = new WsResponse<>();
        responseModel.setCmd(WsResponseCmdEnum.MULTI_MEET_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(multiMeetAgreeResponse);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, toFkClientId);

    }

    @Override
    public void leave(MultiMeetLeaveResponse multiMeetLeaveResponse, Long toFkClientId) {
        multiMeetLeaveResponse.setSubCmd(WsMultiMeetResponseSubCmdEnum.LEAVE.getCmdCode());

        //  向接收方推送
        WsResponse<MultiMeetLeaveResponse> responseModel = new WsResponse<>();
        responseModel.setCmd(WsResponseCmdEnum.MULTI_MEET_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(multiMeetLeaveResponse);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, toFkClientId);

    }

    @Override
    public void busy(MultiMeetBusyResponse multiMeetBusyResponse, Long toFkClientId) {
        multiMeetBusyResponse.setSubCmd(WsMultiMeetResponseSubCmdEnum.BUSY.getCmdCode());

        //  向接收方推送
        WsResponse<MultiMeetBusyResponse> responseModel = new WsResponse<>();
        responseModel.setCmd(WsResponseCmdEnum.MULTI_MEET_MSG.getCmdCode());
        ApiResult<Boolean> result = ApiResult.result(ApiCode.SUCCESS);
        responseModel.setCode(result.getCode());
        responseModel.setMsg(result.getMessage());
        responseModel.setData(multiMeetBusyResponse);
        responseModel.setReqId(null);
        channelSender.sendMsg(responseModel, toFkClientId);
    }


}
