package com.wecloud.im.biz.module.message.service.impl;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.wecloud.can.datasource.mybatisplus.service.impl.BaseServiceImpl;
import com.wecloud.im.biz.module.message.entity.ImClientDevice;
import com.wecloud.im.biz.module.message.mapper.ImClientDeviceMapper;
import com.wecloud.im.biz.module.message.service.ImClientDeviceService;

/**
 * @Author wenzhida
 * @Date 2022/3/2 15:00
 * @Description 客户端设备服务接口实现
 */
@Slf4j
@Service
public class ImClientDeviceServiceImpl extends BaseServiceImpl<ImClientDeviceMapper, ImClientDevice> implements ImClientDeviceService {

    @Autowired
    private ImClientDeviceMapper imClientDeviceMapper;

    @Override
    public int removeOldToken(Long appId, String deviceToken) {
        return imClientDeviceMapper.removeOldToken(appId, deviceToken);
    }

    @Override
    public ImClientDevice getOneByAppIdAndClientIdAndType(Long appId, Long fkClientId, Integer deviceType) {
        return getOne(Wrappers.<ImClientDevice>lambdaQuery()
                .eq(ImClientDevice::getFkAppid, appId)
                .eq(ImClientDevice::getFkClientId, fkClientId)
                .eq(ImClientDevice::getDeviceType, deviceType));
    }
}
