package com.wecloud.im.biz.module.message.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.biz.module.message.entity.ImFriend;
import com.wecloud.im.biz.module.message.param.ImFriendApplyDto;
import com.wecloud.im.biz.module.message.param.ImFriendBaseDto;

/**
 * @Description 好友关系mapper
 * @Author lixiaozhong
 * @Date 2022/1/12 11:41 上午
 */
@Repository
public interface ImFriendMapper extends BaseMapper<ImFriend> {

    IPage<ImFriendBaseDto> getImFriendPageList(@Param("page") Page<ImFriendBaseDto> page, @Param("clientId") String clientId);

    /**
     * 获取待验证的好友列表
     * @param page
     * @param clientId
     * @return
     */
    IPage<ImFriendApplyDto> getApplyFriendPageList(@Param("page") Page<ImFriendApplyDto> page, @Param("clientId") String clientId);

    ImFriendApplyDto getFriendInfo(@Param("clientId") String clientId, @Param("friendClientId") String friendClientId);

    /**
     * 过滤得到真的好友，非好友的friendId将被它忽略
     * @param clientId
     * @param friendClientIds
     * @return
     */
    List<String> filterNegativeFriends(@Param("clientId") String clientId, @Param("friendClientIds") List<String> friendClientIds);

    /**
     * 批量删除好友
     * @param clientId 删除人的clientId
     * @param fkAppId
     * @param friendClientIds 被删除人的clientId列表
     */
    void batchDeleteFriend(@Param("clientId") String clientId, @Param("fkAppId") Long fkAppId, @Param("friendClientIds") List<String> friendClientIds);
}
