package com.wecloud.im.biz.module.message.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.biz.module.message.controller.param.ImClientPageParam;
import com.wecloud.im.biz.module.message.controller.param.ImClientQueryVo;
import com.wecloud.im.biz.module.message.controller.param.ImClientSimpleDto;
import com.wecloud.im.biz.module.message.controller.vo.GetInfoListVo;
import com.wecloud.im.biz.module.message.entity.ImClient;

/**
 * 终端表 Mapper 接口
 *
 * @author wei
 * @since 2021-04-27
 */
@Repository
public interface ImClientMapper extends BaseMapper<ImClient> {

    /**
     * 获取分页对象
     *
     * @param page
     * @param imClientPageParam
     * @return
     */
    IPage<ImClientQueryVo> getImClientPageList(@Param("page") Page page, @Param("param") ImClientPageParam imClientPageParam);

    List<GetInfoListVo> getInfoList(@Param("appId") Long appId, @Param("conversationId") Long conversationId, @Param("clientIds") List<String> clientIds);

    List<ImClientSimpleDto> getSimpleClients(@Param("appId")Long appId, @Param("clientIds")List<String> clientIds);

    List<ImClientSimpleDto> getSimpleClientsByIds(@Param("ids") List<Long> ids);
}
