package com.wecloud.im.biz.module.message.controller.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author wenzhida
 * @Date 2022/3/3 11:19
 * @Description 离线消息内容实体
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "OfflineMsgDto")
public class OfflineMsgDto implements Serializable {

    private static final long serialVersionUID = -7073389493201687249L;

    @ApiModelProperty("会话id")
    private Long conversationId;

    @ApiModelProperty("消息类型")
    private Integer type;

    @ApiModelProperty("消息id")
    private Long msgId;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("撤回时间")
    private Date withdrawTime;

    @ApiModelProperty("发送者客户端id")
    private String sender;

    @ApiModelProperty("内容")
    private String content;

    @ApiModelProperty("0未撤回; 1已撤回")
    private Boolean withdraw;

    @ApiModelProperty("0非事件; 1为事件")
    private Boolean event;

    @ApiModelProperty("0非系统通知; 1为系统通知")
    private Boolean systemFlag;

    @ApiModelProperty("at他人,传入客户端id数组")
    private String at;

    @ApiModelProperty("未读人数统计,全部人已读为0")
    private Integer notReadCount;

    @ApiModelProperty("未接收人数统计,全部人已接收为0")
    private Integer notReceiverCount;

//    @ApiModelProperty("读取时间")
//    private Date readTime;
//
//    @ApiModelProperty("接收时间")
//    private Date receiverTime;

//    @ApiModelProperty("0未接收; 1已接收")
//    private Integer receiverMsgStatus;

}
