package com.wecloud.im.biz.module.message.controller.param.group;

import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;

/**
 * 加入群
 * @Author luozh
 * @Date 2022年05月10日 09:37
 * @Version 1.0
 */
@Getter
@Setter
public class JoinGroupParam {

    /**
     * 邀请进群的用户id
     */
    @NotBlank(message = "inviterUserId 不能为空")
    private String inviterUserId;

    /**
     * 要加入群的用户 ID
     */
    @NotBlank(message = "userIds 不能为空")
    private String userIds;

    /**
     * 要加入的群的群组 ID
     */
    @NotBlank(message = "groupId 不能为空")
    private String groupId;

}
