package com.wecloud.im.biz.module.message.controller.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

import javax.validation.constraints.NotNull;

import com.wecloud.can.core.base.entity.BaseEntity;

/**
 * @Author wenzhida
 * @Date 2022/2/17 15:58
 * @Description 群成员禁言入参
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "群成员禁言入参")
public class MutedGroupMemberParam extends BaseEntity {

    private static final long serialVersionUID = 7572911152462759853L;

    @NotNull
    @ApiModelProperty("会话id")
    private Long conversationId;

    @ApiModelProperty("禁言指定群成员列表 - 群禁言无需入参")
    private List<String> clientIds;

    @NotNull
    @ApiModelProperty("禁言类型 1-取消禁言 2-禁言")
    private Integer mutedType;

}
