package com.wecloud.im.biz.module.message.controller.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

import com.wecloud.can.core.base.entity.BaseEntity;
import com.wecloud.im.biz.enums.DeviceTypeEnum;

/**
 * @Author wenzhida
 * @Date 2022/3/2 18:11
 * @Description 登出操作入参
 */
@Data
@ApiModel(value = "登出操作入参")
public class LogoutParam extends BaseEntity {

    private static final long serialVersionUID = -2718673661281424767L;

    /**
     * 设备类型
     * @see DeviceTypeEnum
     */
    @ApiModelProperty("设备类型 1:ios; 2:android; 3:web; 4:win; 5:mac")
    @NotNull(message = "设备类型不能为空")
    private Integer deviceType;

    @ApiModelProperty("唯一设备id")
    private String uniqueDeviceId;
}
