package com.wecloud.im.biz.module.message.controller.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

/**
 * @Author wenzhida
 * @Date 2022/2/14 16:52
 * @Description 会话信息获取入参
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "会话信息获取入参")
public class ImConversationQueryParam implements Serializable {

    private static final long serialVersionUID = 302200332780152186L;

    @NotNull(message = "会话id不能为空")
    @ApiModelProperty("会话id")
    private Long id;

    @ApiModelProperty("会话属性，1：单聊，2：普通群，3：万人群 4：聊天室")
    private Integer chatType;

}
