package com.wecloud.im.biz.module.message.controller.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

import com.wecloud.im.biz.enums.GroupChatSettingTypeEnum;

/**
 * 群聊设置入参
 * @Author luozh
 * @Date 2022年04月27日 11:20
 * @Version 1.0
 */
@Data
public class GroupChatSettingParam {

    @ApiModelProperty("操作人客户端Id server sdk调用传入")
    private String operatorClientId;

    @ApiModelProperty("设置类型FORBID_ADD_FRIEND 禁止群成员互加好友 FORBID_SEND_PIC 禁止群成员发图片 FORBID_SEND_LINK 禁止群成员发链接" +
            "MUTED 群禁言 NAME修改群名 HEAD_PORTRAIT 修改群头像")
    private GroupChatSettingTypeEnum type;

    @NotNull
    @ApiModelProperty("会话id")
    private Long groupId;

    @ApiModelProperty("开启 true是 false否")
    private Boolean on;

    @ApiModelProperty("群名称 修改群名称时传值")
    private String name;

    @ApiModelProperty("头像 修改群头像时传值")
    private String headPortrait;


}
