package com.wecloud.im.biz.facade;

import lombok.extern.slf4j.Slf4j;

import java.util.Date;

import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.wecloud.im.biz.module.message.entity.ImApplication;
import com.wecloud.im.biz.module.message.service.ImApplicationService;
import com.wecloud.imserver.client.api.ImApplicationFacade;
import com.wecloud.imserver.client.model.ao.CreateApplicationAO;
import com.wecloud.imserver.client.model.ao.UpdateAppSecretAO;
import com.wecloud.imserver.client.model.dto.Result;
import com.wecloud.imserver.client.model.dto.UpdateAppSecretDTO;

/**
 * @author nanqianhao
 * @date 2022/5/26
 * @apiNote
 */
@Slf4j
@Service
@DubboService
public class ImApplicationFacadeImpl implements ImApplicationFacade {

    @Autowired
    private ImApplicationService imApplicationService;



    @Override
    public Result<Boolean> updateAppSecret(UpdateAppSecretAO updateSecretAO) {
        log.info("更新Secret传入参数为{}",updateSecretAO);
        ImApplication application = imApplicationService.getOne(new LambdaQueryWrapper<ImApplication>().eq(ImApplication::getId, updateSecretAO.getId()).eq(ImApplication::getAppKey,updateSecretAO.getAppKey()));
        UpdateAppSecretDTO updateAppSecretDTO = new UpdateAppSecretDTO();
        updateAppSecretDTO.setId(updateSecretAO.getId());
        updateAppSecretDTO.setAppKey(updateSecretAO.getAppKey());
        updateAppSecretDTO.setNewAppSecret(updateSecretAO.getAppSecret());
        application.setAppSecret(updateSecretAO.getAppSecret());
        application.setUpdateTime(new Date());
        boolean result = imApplicationService.updateById(application);
        log.info("更新Secret返回结果为{}",updateAppSecretDTO);
        return Result.getSuccessResult(result);
    }

    @Override
    public Result<Boolean> createApplication(CreateApplicationAO createApplicationAO) {
        log.info("创建应用传入的参数为{}",createApplicationAO);
        ImApplication imApplication = new ImApplication();
        if (createApplicationAO.getOwnerId()==null||"".equals(createApplicationAO.getOwnerId())){
            return Result.getBusinessException("请传入使用用户id", null);
        }
        if (createApplicationAO.getId()==null){
            return Result.getBusinessException("请传入新增应用id", null);
        }
        imApplication.setId(createApplicationAO.getId());
        imApplication.setAppName(createApplicationAO.getAppName());
        imApplication.setAppKey(createApplicationAO.getAppKey());
        imApplication.setAppSecret(createApplicationAO.getAppSecret());
        imApplication.setOwnerId(createApplicationAO.getOwnerId());
        imApplication.setCompanyId(createApplicationAO.getCompanyId());
        imApplication.setStatus(1);
        imApplication.setCreateTime(new Date());
        log.info("新建的应用信息为{}",imApplication);
        boolean saveResult = imApplicationService.save(imApplication);
        return Result.getSuccessResult(saveResult);
    }

    //@Override
    //public Result<List<ApplicationDTO>> listApplications(ListApplicationQueryAO listApplicationQueryAO) {
    //    log.info("查看应用列表传入的参数为{}",listApplicationQueryAO);
    //    if (listApplicationQueryAO.getTenantId()==null||"".equals(listApplicationQueryAO.getTenantId())){
    //        return Result.getBusinessException("请传入租户id", null);
    //    }
    //    //List<ImApplication> list = imApplicationService.list(new LambdaQueryWrapper<ImApplication>().eq(ImApplication::getTenantId, listApplicationQueryAO.getTenantId()));
    //    //List<ApplicationDTO> applicationDTOs = new ArrayList<>();
    //    //list.forEach(ImApplication->{
    //    //    ApplicationDTO applicationDTO = new ApplicationDTO();
    //    //    BeanUtils.copyProperties(ImApplication,applicationDTO);
    //    //    applicationDTOs.add(applicationDTO);
    //    //});
    //    log.info("返回的应用列表为{}",applicationDTOs);
    //    return Result.getSuccessResult(applicationDTOs);
    //}

    @Override
    public Result<Boolean> updateApplication(CreateApplicationAO createApplicationAO) {
        log.info("编辑应用传入参数为{}",createApplicationAO);
        ImApplication application = imApplicationService.getOne(new LambdaQueryWrapper<ImApplication>().eq(ImApplication::getId, createApplicationAO.getId()));
        application.setAppName(createApplicationAO.getAppName());
        application.setUpdateTime(new Date());
        boolean updateResult = imApplicationService.updateById(application);
        log.info("编辑的应用信息为{}",application);
        return Result.getSuccessResult(updateResult);
    }

    @Override
    public Result<Boolean> deleteApplication(Long applicationId) {
        log.info("删除应用传入应用id参数为{}",applicationId);
        ImApplication application = imApplicationService.getOne(new LambdaQueryWrapper<ImApplication>().eq(ImApplication::getId, applicationId));
        application.setStatus(3);
        application.setUpdateTime(new Date());
        log.info("删除应用信息为{}",application);
        boolean deleteResult = imApplicationService.updateById(application);
        return Result.getSuccessResult(deleteResult);
    }
}
