package com.wecloud.im.biz.externalaccess.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

import com.wecloud.im.biz.enums.RelationEnum;
import com.wecloud.im.biz.enums.SexEnum;

/**
 * @Author wenzhida
 * @Date 2022/2/23 11:27
 * @Description 用户基本信息
 */
@Data
public class UserBaseDto implements Serializable {

    private static final long serialVersionUID = -6070534424163538590L;

    /**
     * userId
     */
    @ApiModelProperty("userId")
    private String userId;

    @ApiModelProperty("蓝豆号")
    private String idNumber;

    @ApiModelProperty("手机号码")
    private String phone;

    /**
     * 性别
     * @see SexEnum
     */
    @ApiModelProperty("性别 1-男 2-女 3-未知")
    private Integer sex;

    @ApiModelProperty("昵称")
    private String nickname;

    /**
     * 头像路径url
     */
    @ApiModelProperty("头像路径url")
    private String headPortrait;

    /**
     * 与我关系
     * @see RelationEnum
     */
    @ApiModelProperty("与我关系 1-陌生人 2-好友 3-被我拉黑")
    private Integer relation;

    @ApiModelProperty("好友的昵称备注")
    private String friendName;

}
