package com.wecloud.im.biz.externalaccess.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

/**
 * 修改用户入参
 * @Author luozh
 * @Date 2022年04月18日 15:19
 * @Version 1.0
 */
@Data
public class ModifyUserParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * userId
     */
    @NotNull(message = "userId不可为空")
    @ApiModelProperty("userId")
    private Long userId;

    /**
     * 昵称
     */
    @NotNull(message = "昵称不能为空")
    @ApiModelProperty("昵称")
    private String nickname;

    /**
     * 头像url
     */
    @NotNull(message = "头像url不能为空")
    @ApiModelProperty("头像url")
    private String headPortrait;

}
