package com.wecloud.im.biz.externalaccess.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

/**
 * @Author wenzhida
 * @Date 2022/2/21 23:10
 * @Description 更换手机号入参
 */
@Data
public class ChangePhoneParam implements Serializable {

    private static final long serialVersionUID = -4477687567118083363L;

    /**
     * userId
     */
    @NotNull(message = "userId不可为空")
    @ApiModelProperty("userId")
    private String userId;

    /**
     * 电话号码
     */
    @NotNull(message = "电话号码不可为空")
    @ApiModelProperty("电话号码")
    private String phone;

    /**
     * 验证码
     */
    @NotNull(message = "验证码不可为空")
    @ApiModelProperty("验证码")
    private String verifyCode;

}
