package com.wecloud.im.biz.event.listener;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import com.wecloud.im.biz.module.message.service.ImCallbackService;
import com.wecloud.im.server.event.ChannelStatusChangeEvent;

/**
 *
 * @Author luozh
 * @Date 2022年04月22日 09:47
 * @Version 1.0
 */
@Component
public class ChannelStatusChangeEventListener implements ApplicationListener<ChannelStatusChangeEvent> {

    @Autowired
    private ImCallbackService callbackService;

    @Async
    @Override
    public void onApplicationEvent(ChannelStatusChangeEvent event) {
        Long applicationId = event.getApplicationId();

        Long clientId = event.getClientId();

        Integer status = event.getStatus();

        Integer deviceType = event.getDeviceType();

        Long time = event.getTime();

        String clientIp = event.getClientIp();

        callbackService.clientOnlineStatusChange(applicationId, clientId, status, deviceType, time, clientIp);
    }
}
