package com.wecloud.im.biz.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import com.wecloud.can.core.base.enums.BaseEnum;

/**
 * 付款状态，0-未付款，1-用户已付款,待审核，2-用户已付款,审核通过，3-退款中，99-已退款
 **/
@Getter
@AllArgsConstructor
public enum StatePaymentStatusEnum implements BaseEnum {

//    0-UNPAID, 1-PAYING, 2-PAID, 3-REFUNDING, 99-REFUNDED

    /**
     * 未付款
     **/
    UNPAID(0, "未付款"),
    /**
     * 付款中
     **/
    PAYING(1, "用户已付款,待审核"),
    /**
     * 已付款
     **/
    PAID(2, "用户已付款,审核通过"),
    /**
     * 退款中
     **/
    REFUNDING(3, "退款中"),
    /**
     * 已退款
     **/
    REFUNDED(99, "已退款");

    private final Integer code;
    private final String desc;

}
