package com.wecloud.im.biz.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import com.wecloud.can.core.base.enums.BaseEnum;

/**
 * 好友关系 1：待确定，2：已确认，3：已拒绝，4：已删除
 * @author lixiaozhong
 *
 */
@Getter
@AllArgsConstructor
public enum FriendStateEnum implements BaseEnum {

    /**
     * 待确认
     **/
    UNSURE(1, "待确认"),
    /**
     * 已确认
     **/
    CONFORM(2, "已确认"),
    REJECT(3, "已拒绝"),
    DEL(4, "已删除");

    private final Integer code;
    private final String desc;

}
