package com.wecloud.im.biz.enums;

/**
 * @Author wenzhida
 * @Date 2022/4/27 10:28
 * @Description 添加好友来源枚举
 */
public enum FriendSourceEnum {

    // 名片
    CARD("CARD", "名片"),
    // 二维码
    QR_CODE("QR_CODE", "二维码"),
    // SEARCH 搜索
    SEARCH("SEARCH", "搜索"),
    // 群聊
    GROUP_CHAT("GROUP_CHAT", "群聊"),
    ;

    FriendSourceEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private final String code;
    private final String desc;

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}
