package com.wecloud.im.biz.enums;

import com.wecloud.can.core.base.enums.BaseEnum;

/**
 * @Description 会话类型
 * @Author lixiaozhong
 * @Date 2022/1/11 4:58 下午
 */
public enum ChatTypeEnum implements BaseEnum {

    /**
     * 单聊
     */
    SINGLE(1, "单聊"),
    /**
     * 普通群
     */
    NORMAL_GROUP(2, "普通群"),
    /**
     * 万人群
     */
    THOUSAND_GROUP(3, "万人群"),
    /**
     * 聊天室
     */
    CHAT_ROOM(4, "聊天室"),
    /**
     * 临时会话
     */
    TEMP(5, "临时会话"),
    /**
     * 系统会话
     */
    SYSTEM(6, "系统会话"),

    ;

    private final Integer code;
    private final String desc;

    ChatTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }
}
