package com.wecloud.im.biz.core.post;

import java.util.Date;

import com.wecloud.can.core.util.SnowflakeUtil;
import com.wecloud.im.biz.module.message.entity.ImApplication;
import com.wecloud.im.biz.module.message.entity.ImClient;
import com.wecloud.im.biz.module.message.entity.ImConversation;
import com.wecloud.im.biz.module.message.entity.ImMessage;
import com.wecloud.im.server.enums.MsgTypeEnum;

/**
 * 消息构造者
 * @Author luozh
 * @Date 2022年05月13日 14:20
 * @Version 1.0
 */
public class MessageBuilder {


    /**
     * 构建普通消息
     * @Author luozh
     * @Date 2022年05月13日 02:30:27
     * @param type
     * @param application
     * @param sender
     * @param receiver
     * @Return
     */
    public static ImMessage buildNormalMessage(MsgTypeEnum type, ImApplication application,
                                               ImClient sender, ImConversation conversation) {
        long messageId = SnowflakeUtil.getId();
        ImMessage imMessage = new ImMessage();
        //  保存消息至消息表
        imMessage.setId(messageId);
        imMessage.setMsgType(type.getUriCode());
        imMessage.setFkAppid(application.getId());
        imMessage.setSender(sender.getId());
        imMessage.setWithdraw(false);
        imMessage.setEvent(false);
        imMessage.setSystemFlag(false);
        imMessage.setSendStatus(2);
        imMessage.setFkConversationId(conversation.getId());
        imMessage.setCreateTime(new Date());
        return imMessage;
    }


    /**
     * 构建事件消息
     * @Author luozh
     * @Date 2022年05月13日 02:30:27
     * @param type
     * @param application
     * @param sender
     * @param receiver
     * @Return
     */
    public static ImMessage buildEventMessage(MsgTypeEnum type, ImApplication application,
                                              ImClient sender, ImConversation conversation,
                                              String content) {
        long messageId = SnowflakeUtil.getId();
        ImMessage imMessage = new ImMessage();
        //  保存消息至消息表
        imMessage.setId(messageId);
        imMessage.setMsgType(type.getUriCode());
        imMessage.setFkAppid(application.getId());
        imMessage.setSender(sender.getId());
        imMessage.setContent(content);
        imMessage.setWithdraw(false);
        imMessage.setEvent(true);
        imMessage.setSystemFlag(false);
        imMessage.setSendStatus(2);
        imMessage.setFkConversationId(conversation.getId());
        imMessage.setCreateTime(new Date());
        return imMessage;
    }

}
