package com.jumeirah.common.param;

import io.geekidea.springbootplus.framework.core.pagination.BasePageOrderParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <pre>
 * 行程表 分页参数对象
 * </pre>
 *
 * @author wei
 * @date 2020-09-29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "行程表分页参数")
public class McStrokePageParam extends BasePageOrderParam {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("行程类型，-1-全部，0-单程，1-往返行程，2-货运，3-医疗")
    private Integer type;

    @ApiModelProperty("主键id")
    private Long id;

    @ApiModelProperty("状态，-1全部，0-审核中，1-进行中，2-已完成，99-取消")
    private Integer status;

    @ApiModelProperty("开始时间")
    private String startTime;

    @ApiModelProperty("结束时间")
    private String endTime;

    @ApiModelProperty("申请人")
    private String applicant;

}
