package com.jumeirah.common.mq;


import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @author: JJww
 * @Date:2019-07-19
 */

@Component
public class Queue {

    @Autowired
    private AmqpTemplate rabbitTemplate;

    @Value("${spring.rabbitmq.order-queue-name}")
    private String orderQueueName;

    /**
     * 推送订单状态到客服系统
     *
     * @param orderInteractionModel
     */
    public void pushOrder(String stroke) {
        rabbitTemplate.convertAndSend(orderQueueName, stroke);
    }


}