package com.wecloud.im.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.entity.ImMessage;
import com.wecloud.im.param.GetReadersParam;
import com.wecloud.im.param.ImHistoryMessagePageParam;
import com.wecloud.im.param.ImMessagePageParam;
import com.wecloud.im.param.ImMessageQueryVo;
import com.wecloud.im.vo.OfflineMsgDto;
import com.wecloud.im.vo.ReaderVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 消息存储表 Mapper 接口
 *
 * @author wei
 * @since 2021-04-29
 */
@Repository
public interface ImMessageMapper extends BaseMapper<ImMessage> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    ImMessageQueryVo getImMessageById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param imMessagePageParam
     * @return
     */
    IPage<ImMessageQueryVo> getImMessagePageList(@Param("page") Page page, @Param("param") ImMessagePageParam imMessagePageParam);

    /**
     * 查询某个会话历史消息分页列表
     *
     * @param page
     * @param imHistoryMessagePageParam
     * @return
     */
    IPage<OfflineMsgDto> getHistoryMsgConversationId(@Param("page") Page page, @Param("param") ImHistoryMessagePageParam imHistoryMessagePageParam);

    IPage<OfflineMsgDto> getHistoryMsgConversationIdNew(@Param("page") Page page, @Param("param") ImHistoryMessagePageParam imHistoryMessagePageParam);

    /**
     * 根据客户端id与会话id 查询离线消息
     *
     * @param clientId
     * @param conversationId
     * @return
     */
    List<OfflineMsgDto> getOfflineListByClientAndConversation(@Param("clientId") Long clientId, @Param("conversationId") Long conversationId);

    /**
     * 查询会话接收的的最后一条消息
     *
     * @param clientId
     * @param conversationId
     * @return
     */
    OfflineMsgDto getReceivedLastMsgByConversationId(@Param("clientId") Long clientId, @Param("conversationId") Long conversationId);


    /**
     * 查询会话的最后一条消息
     *
     * @param conversationId
     * @return
     */
    OfflineMsgDto getLastMsgByConversationId(@Param("conversationId") Long conversationId, @Param("currentFkClientId") Long currentFkClientId);

    /**
     * 获取一条消息已读人员和未读人员
     * @param currentClientId
     * @param param
     * @return
     */
    List<ReaderVo> getReaders(@Param("currentClientId") Long currentClientId, @Param("param") GetReadersParam param);

    List<ImMessage> syncListMessage(@Param("beginMessageDate")Date beginMessageDate,@Param("appId") Long appId);
}
