package com.wecloud.dispatch.general.extend.impl;

import com.wecloud.dispatch.ActionDispatcher;
import com.wecloud.dispatch.common.RequestVO;
import com.wecloud.dispatch.extend.ActionMessage;
import com.wecloud.dispatch.extend.impl.DefaultActionMessage;
import com.wecloud.dispatch.general.extend.ActionMessageResolver;
import org.springframework.stereotype.Component;

/**
 * @author lixiaozhong
 */
@Component
public class ActionMessageResolverImpl implements ActionMessageResolver {

	@Override
	public ActionMessage resolver(ActionDispatcher actionDispatcher, RequestVO data) {
		ActionMessage am = new DefaultActionMessage();
		am.setAction("");

		if (data == null) {
			return am;
		}

		String action = data.getAction();
		String path = actionDispatcher.getActionRegistry().getPath(action, null);

		am.setMessage(data);
		am.setAction(path);
		return am;
	}

}
