package com.wecloud.dispatch;

import com.wecloud.dispatch.annotation.ActionMapping;
import com.wecloud.im.ws.model.WsResponse;
import com.wecloud.im.ws.model.request.PushVO;
import com.wecloud.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 这是一个示例，前端websocket的写法：

 {
   "reqId":"123123123",
   "action":"/sendtest/gogo",
   "hello":"我的测试",
   "push": {
      "title": "标题",
      "subTitle": "子标题"
   },
   "pList": [
      {
         "title": "p1标题",
         "subTitle": "p1子标题"
      },{
         "title": "p2标题",
         "subTitle": "p2子标题"
   }],
   "pSet": [
      {
         "title": "p3标题",
         "subTitle": "p3子标题"
      },{
         "title": "p4标题",
         "subTitle": "p4子标题"
   }],
   "pMap": {
      "testKey1": "testValue1",
      "testKey2": "testValue2"
   }
 }

 * @author lixiaozhong
 */
@Component
@ActionMapping(value = "sendtest")
@Slf4j
public class WsTestAction {

	/**
	 * test
	 * @param reqId
	 * @param nihao
	 * @param push
	 * @param pList
	 * @param pSet
	 * @param pMap
	 */
	@ActionMapping(value = "gogo")
	public WsResponse<Boolean> testMyDispatch(String reqId,
										 @RequestParam("hello") String nihao,
										 PushVO push,
										 ArrayList<PushVO> pList,
										 Set<PushVO> pSet,
										 Map<String, String> pMap) {
		log.info(reqId);
		log.info(nihao);
		log.info(JsonUtils.encodeJson(push));
		log.info(JsonUtils.encodeJson(pList));
		log.info(JsonUtils.encodeJson(pSet));
		log.info(JsonUtils.encodeJson(pMap));
		WsResponse<Boolean> wsResponse = new WsResponse<>();
		wsResponse.setCmd(0).setData(true).setCode(0).setMsg("msg").setReqId(reqId);
		return wsResponse;
	}
}
