package com.jumeirah.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jumeirah.common.entity.VersionControl;
import com.jumeirah.common.mapper.VersionControlMapper;
import com.jumeirah.common.param.VersionControlPageParam;
import com.jumeirah.common.param.VersionControlQueryVo;
import com.jumeirah.common.service.VersionControlService;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * App版本控制 服务实现类
 *
 * @author giao
 * @since 2020-10-26
 */
@Slf4j
@Service
public class VersionControlServiceImpl extends BaseServiceImpl<VersionControlMapper, VersionControl> implements VersionControlService {

    @Autowired
    private VersionControlMapper versionControlMapper;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveVersionControl(VersionControl versionControl) throws Exception {
        return super.save(versionControl);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateVersionControl(VersionControl versionControl) throws Exception {
        return super.updateById(versionControl);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteVersionControl(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public VersionControlQueryVo getVersionControlById(Long id) throws Exception {
        return versionControlMapper.getVersionControlById(id);
    }

    @Override
    public Paging<VersionControlQueryVo> getVersionControlPageList(VersionControlPageParam versionControlPageParam) throws Exception {
        Page<VersionControlQueryVo> page = new PageInfo<>(versionControlPageParam, OrderItem.desc(getLambdaColumn(VersionControl::getCreateTime)));
        IPage<VersionControlQueryVo> iPage = versionControlMapper.getVersionControlPageList(page, versionControlPageParam);
        return new Paging<VersionControlQueryVo>(iPage);
    }

}
