package com.wecloud.im.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

import com.wecloud.im.sdk.enums.GroupChatSettingTypeEnum;

/**
 * 群聊设置入参
 * @Author luozh
 * @Date 2022年04月27日 11:20
 * @Version 1.0
 */
@Data
public class GroupChatSettingParam {

    @ApiModelProperty("设置类型FORBID_ADD_FRIEND 禁止群成员互加好友 FORBID_SEND_RED_PACKETS 禁止群成员发红包 FORBID_SEND_PIC 禁止群成员发图片 " +
            "FORBID_SEND_LINK 禁止群成员发链接")
    private GroupChatSettingTypeEnum type;

    @NotNull
    @ApiModelProperty("会话id")
    private Long groupId;

    @ApiModelProperty("开启 true是 false否")
    private Boolean on;
}
