package com.wecloud.im.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.wecloud.im.entity.ImClient;
import com.wecloud.im.entity.ImClientBlacklist;
import com.wecloud.im.mapper.ImClientBlacklistMapper;
import com.wecloud.im.param.ImClientBlacklistPageParam;
import com.wecloud.im.param.ImClientBlacklistQueryVo;
import com.wecloud.im.param.add.ImClientBlacklistUpdate;
import com.wecloud.im.service.ImClientBlacklistService;
import com.wecloud.im.service.ImClientService;
import com.wecloud.utils.SnowflakeUtil;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.exception.BusinessException;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * 黑名单 服务实现类
 *
 * @author wei
 * @since 2021-06-17
 */
@Slf4j
@Service
public class ImClientBlacklistServiceImpl extends BaseServiceImpl<ImClientBlacklistMapper, ImClientBlacklist> implements ImClientBlacklistService {

    @Autowired
    private ImClientBlacklistMapper imClientBlacklistMapper;

    @Autowired
    private ImClientService imClientService;

    @Override
    public boolean isBeBlack(String currentClientId, String toClientId) {
        ImClientBlacklist one = this.getOne(new QueryWrapper<ImClientBlacklist>().lambda()
                .eq(ImClientBlacklist::getClientIdPrevent, currentClientId)
                .eq(ImClientBlacklist::getClientIdBePrevent, toClientId));

        return one != null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Boolean> addImClientBlacklist(ImClientBlacklistUpdate imClientBlacklistUpdate) {
        ImClient currentClient = imClientService.getCurrentClient();
        if (currentClient == null) {
            throw new BusinessException("当前用户登录信息失效");
        }
        ImClient beBlacker = imClientService.getOne(new QueryWrapper<ImClient>().lambda()
                .eq(ImClient::getFkAppid, currentClient.getFkAppid())
                .eq(ImClient::getClientId, imClientBlacklistUpdate.getClientIdBePrevent()));
        if (beBlacker == null) {
            throw new BusinessException("查无用户信息");
        }
        ImClientBlacklist imClientBlacklist = new ImClientBlacklist();
        imClientBlacklist.setId(SnowflakeUtil.getId());
        imClientBlacklist.setCreateTime(new Date());
        imClientBlacklist.setFkAppid(currentClient.getFkAppid());
        imClientBlacklist.setClientIdPrevent(currentClient.getClientId());
        imClientBlacklist.setClientIdBePrevent(beBlacker.getClientId());
        this.save(imClientBlacklist);

        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Boolean> removeImClientBlacklist(ImClientBlacklistUpdate imClientBlacklistUpdate) {
        // 操作者
        ImClient currentClient = imClientService.getCurrentClient();
        if (currentClient == null) {
            throw new BusinessException("当前用户登录信息失效");
        }
        // 被拉黑者
        ImClient beBlacker = imClientService.getOne(new QueryWrapper<ImClient>().lambda()
                .eq(ImClient::getFkAppid, currentClient.getFkAppid())
                .eq(ImClient::getClientId, imClientBlacklistUpdate.getClientIdBePrevent()));
        if (beBlacker == null) {
            throw new BusinessException("查无用户信息");
        }
        // 删除
        this.remove(new QueryWrapper<ImClientBlacklist>().lambda()
                .eq(ImClientBlacklist::getClientIdPrevent, currentClient.getClientId())
                .eq(ImClientBlacklist::getClientIdBePrevent, beBlacker.getClientId()));
        return ApiResult.ok();
    }

    @Override
    public ApiResult<Paging<ImClientBlacklistQueryVo>> getImClientBlacklistPageList(ImClientBlacklistPageParam imClientBlacklistPageParam) {
        Page<ImClientBlacklistQueryVo> page = new PageInfo<>(imClientBlacklistPageParam);
        ImClient currentClient = imClientService.getCurrentClient();
        IPage<ImClientBlacklistQueryVo> imClientBlacklistPageList = imClientBlacklistMapper.getImClientBlacklistPageList(page, currentClient.getClientId());
        Paging<ImClientBlacklistQueryVo> imClientBlacklistQueryVoPaging = new Paging<>(imClientBlacklistPageList);
        return ApiResult.ok(imClientBlacklistQueryVoPaging);
    }

}
