package com.wecloud.im.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @Author wenzhida
 * @Date 2022/3/15 23:09
 * @Description 多人音视频房间
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "多人音视频房间")
public class ImMultiRtcRoom extends BaseEntity {

    private static final long serialVersionUID = -523597842194055670L;

    @NotNull(message = "主键id不能为空")
    @ApiModelProperty("主键id")
    @TableId(value = "id", type = IdType.INPUT)
    private Long id;

    @ApiModelProperty("应用appid")
    private Long fkAppid;

    @ApiModelProperty("房间id")
    private String roomId;

    /**
     * 多人音视频房间状态枚举
     * @see com.wecloud.im.enums.MultiRtcRoomStateEnum
     */
    @ApiModelProperty("房间状态，1：已创建，2：会议中，3：会议结束")
    private Integer state;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

}
