/*
 * Copyright 2019-2029 geekidea(https://github.com/geekidea)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.wecloud.im.sdk.enums;

import io.geekidea.springbootplus.framework.common.enums.BaseEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 好友关系 1：待确定，2：已确认，3：已拒绝，4：已删除
 * @author lixiaozhong
 *
 */
@Getter
@AllArgsConstructor
public enum FriendStateEnum implements BaseEnum {

    /**
     * 待确认
     **/
    UNSURE(1, "待确认"),
    /**
     * 已确认
     **/
    CONFORM(2, "已确认"),
    REJECT(3, "已拒绝"),
    DEL(4, "已删除");

    private final Integer code;
    private final String desc;

}
