package com.wecloud.im.service;

import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

import java.util.List;

import org.springframework.web.bind.annotation.RequestBody;

import com.wecloud.im.entity.ImApplication;
import com.wecloud.im.entity.ImConversationMembers;
import com.wecloud.im.friend.param.ImFriendApplyParam;
import com.wecloud.im.param.ApiImConversationMembersPageParam;
import com.wecloud.im.param.ApiImConversationMembersQueryVo;
import com.wecloud.im.param.ChatSettingParam;
import com.wecloud.im.param.ImConvMemeClientRemarkNameParam;
import com.wecloud.im.param.ImConversationMembersPageParam;
import com.wecloud.im.param.ImConversationMembersQueryVo;
import com.wecloud.im.param.ListConversationMembersParam;
import com.wecloud.im.param.SetAdminsParam;
import com.wecloud.im.param.add.ImConversationMemAttrUpdate;
import com.wecloud.im.vo.ConversationMemberVo;

/**
 * 会话成员表 服务类
 *
 * @author wei
 * @since 2021-05-07
 */
public interface ImConversationMembersService extends BaseService<ImConversationMembers> {


    /**
     * 服务端api-会话成员表分页列表
     *
     * @param apiImConversationMembersPageParam
     * @param imApplication
     * @return
     */
    ApiResult<List<ApiImConversationMembersQueryVo>> getRestApiImConversationMembersList(ApiImConversationMembersPageParam apiImConversationMembersPageParam, ImApplication imApplication);


    /**
     * 添加或修改会话成员备注
     * @param param
     * @return
     */
    void saveOrUpdateClientRemarkName(ImConvMemeClientRemarkNameParam param);


    /**
     * 会话成员表分页列表
     *
     * @param param
     * @return
     * @throws Exception
     */
    List<ConversationMemberVo> getImConversationMembersList(ListConversationMembersParam param);


    Boolean saveOrUpdateAttr(ImConversationMemAttrUpdate imConversationMemAttrUpdate);

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteImConversationMembers(Long id);

    /**
     * 根据会话id做删除
     * @param conversationId 会话id
     */
    void deleteByConversationId(Long conversationId);

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    ImConversationMembersQueryVo getImConversationMembersById(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param imConversationMembersPageParam
     * @return
     * @throws Exception
     */
    Paging<ImConversationMembersQueryVo> getImConversationMembersPageList(ImConversationMembersPageParam imConversationMembersPageParam) throws Exception;

    /**
     * 根据用户id 获取千人群id列表
     * @param clientId 用户id
     * @return
     */
    List<Long> findThousandGroupsByClientId(Long clientId);

    /**
     * 批量设置群成员
     * @param param
     * @param fkClientIds
     */
    void setAdminsForConversation(SetAdminsParam param, List<Long> fkClientIds);

    /**
     * 置顶
     * @Author luozh
     * @Date 2022年04月25日 06:24:43
     * @param
     * @Return
     */
    Boolean chatSetting(ChatSettingParam param);

    /**
     * 群成员添加好友
     * @Author luozh
     * @Date 2022年04月28日 11:48:42
     * @param param
     * @Return
     */
    Boolean addUser(@RequestBody ImFriendApplyParam param);
}
